# 프로세스와 스레드의 차이

CS에서 프로세스와 스레드의 차이점은 기술 인터뷰에서 자주 등장하는 주제이다. 서로 관련되고 유사하므로 차이점을 아는 것이 매우 중요하다.

## 프로그램(Program)

특정 작업을 위한 명령문의 집합으로, 정적인 파일로 기기 내 저장공간에 저장되어있지만 메모리에 올라가있지 않은 **실행 가능한 파일**이다.

<br/>

## 프로세서(Processor)
프로세서는 CPU, 그래픽 프로세서(graphic processor), 입출력 프로세서(I/O processor)와 같은 하드웨어 처리기를 뜻한다.  
옛날엔 컴퓨터가 한번에 하나의 동작밖에 수행하지 못했다. 하지만 다중 작업을 가능하게 하는 멀티태스킹\* 기능이 나오면서 컴퓨터가 프로세스 여러 개를 함께 돌리는 것이 가능해졌다.  

_\* 멀티 태스킹: 컴퓨터  시스템 내에 응용프로그램을 동시에 실행시키거나 한 응용프로그램 내에서 여러 태스크를 동시에 실행시키는 기법이다._

<br>

## 프로세스(Process)

프로세스는 메모리에 올라와 실행 중인 프로그램 인스턴스\*이다. 프로그램의 실행 단위라고 할 수 있다.  
프로그램이 실행되면 메모리에 올라가고 운영체제로부터 시스템 자원(CPU 시간, 주소 공간, `Code, Data, Heap, Stack`의 구조로 되어있는 독립된 메모리 영역)을 할당받는다.

_\* 인스턴스: 개별 요소를 의미한다._

* **프로세스 메모리 영역**
   프로세스는 코드 영역, 데이터 영역, 힙 영역, 스택 영영 4개의 메모리 영역으로 구성되며, 모두 사용자 공간에 형성된다.
   * 코드(Code) 영역: 프로세스 코드(사용자가 작성한 코드, 라이브러리 함수 코드)가 적재되는 영역이다.
   * 데이터(Data) 영역: 프로세스의 전역 변수(사용자가 선언한 전역 변수와 라이브러리에 선언된 전역 변수)들과 정적 변수들이 적재되는 영역이다.
   * 힙(Heap) 영역: 프로세스가 실행 중에 동적 할당받는 영역이다.
   * 스택(Stack) 영역: 함수가 호출될 때, 지역변수, 매개변수, 함수로부터 돌아갈 주소 등이 저장되는 영역

<br>

### 프로세스의 특징

- 프로세스는 각각 독립된 메모리 영역(`Code`, `Data`, `Stack`, `Heap` 의 구조)을 할당받는다.
- 프로세스당 최소 1개의 스레드를 가지고 있다.
- 프로세스는 서로 독립적인 메모리 공간을 가지므로, 다른 프로세스의 영역이나 자료구조에 바로 접근할 수 없다.
- 프로세스가 다른 프로세스의 자원에 접근하려면 프로세스 간의 통신(IPC, inter-process communication)\*을 사용해야 한다.
- 운영체제는 프로세스마다 고유한 번호(프로세스 ID)를 할당한다.
- 프로세스에 관한 정보는 운영체제 커널에 의해 관리된다.
- 프로세스를 만들고, 실행하고, 대기시키고, 종료시키는 모든 관리는 커널에 의해 수행된다.
<img src="https://velog.velcdn.com/images%2Fgparkkii%2Fpost%2F3ad2bcba-e652-4213-a10c-78b5a13c95b0%2FKakaoTalk_Photo_2021-01-02-18-02-01.jpeg" alt="ProcessMemory" width="500px" />

<br>

_\* 프로세스 간의 통신([IPC](https://github.com/da-in/tech-interview-study/blob/main/CS%20Deep%20Dive/Operating%20System/IPC(Inter%20Process%20Communication).md), inter-process communication): 프로세스들 사이에 서로 데이터를 주고받는 행위 또는 그에 대한 방법이나 경로를 뜻한다. `파일`, `파이프`, `신호`, `소켓`, `메세지큐` 등_  

### 프로세스의 문제점

프로세스를 실행 단위로 하는 멀티태스킹은 프로세스 생성과 컨텍스트 스위칭\*의 오버헤드\*가 크고, 프로세스가 통신에 어려움이 있어 비효율적이다.  
_\* 컨텍스트 스위칭: 실행 중인 프로세스를 중단시키고 다른 프로세스를 실행시키는 것이다._  
_\* 오버헤드: 어떤 처리를 하기 위해 들어가는 간접적인 처리 시간, 메모리 등을 말한다._

<br/>

## 스레드(Thread)

> In computer science, a thread of execution is the smallest sequence of programmed instructions that can be managed independently by a scheduler, which is typically a part of the operating system _(wiki)_

> 컴퓨터 분야에서 실행되는 스레드는 일반적으로 운영체제의 일부인 스케줄러에 의해 독립적으로 관리 될 수 있는 프로그래밍 된 명령어의 가장 작은 시퀀스다. _(위키)_

스레드의 출현으로, 프로세스는 여러 스레드를 담는 컨테이너로 개념이 수정되었다. 스레드는 어떠한 프로그램, 프로세스 내에서 실행되는 흐름의 단위이다.  
일반적으로 하나의 프로그램은 하나 이상의 프로세스를 가지고 있고, **하나의 프로세스는 반드시 하나 이상의 스레드를 갖는다**.  
즉 프로세스를 생성하면 기본적으로 하나의 (메인)스레드가 생성되는 셈이다.

### 스레드의 특징

- 스레드는 프로세스 내에서 각각 `Stack`만 따로 할당받고 `Code`, `Data`, `Heap` 영역은 공유한다.
- 모든 스레드는 논리적으로 프로세스에 포함되며 개별적으로 존재할 수 없다.
- 스레드는 동일한 주소 공간을 공유하므로 서로 직접 통신할 수 있다.
- 한 스레드가 프로세스 자원을 변경하면, 다른 이웃 스레드(sibling thread)도 변경 결과를 즉시 볼 수 있다.
- 프로세스에 비해 생성과 종료 등이 빠르고 가볍다.

<img src="https://user-images.githubusercontent.com/66757141/210286806-c653faaa-a276-4054-b07e-4c8da24cc071.jpg" alt="Threads" width="500px" />

<!-- [_Reference | UNIX Thread_](https://www.cs.miami.edu/home/wuchtys/CSC322-21S/Content/UNIXProgramming/UNIXThreads.shtml) -->

<br/>

## 멀티 프로세스(Multi Process)

하나의 프로그램에서 여러 개의 프로세스를 실행하는 것이다. 
대표적인 예로 웹 브라우저의 상단 탭이나 새 창을 들 수 있다.

* **장점**
   * 여러 개의 자식 프로세스 중 하나에 문제가 발생하면 그 자식 프로세스만 죽는 것 이상으로 다른 영향이 확산되지 않는다.

* **단점**
   * **프로세스 생성의 큰 오버헤드**  
      모든 프로세스들은 독립적인 메모리 공간을 가지므로, 프로세스 관리를 위한 구조체가 생성되고 초기화 되는데 많은 시간이 걸린다.
   * **프로세스 [Context Switching](https://github.com/da-in/tech-interview-study/blob/main/CS%20Deep%20Dive/Operating%20System/PCB%20&%20Context%20Switching.md)의 큰 오버헤드**  
      프로세스는 각각의 독립된 메모리 영역을 할당받았기 때문에 프로세스 사이에서 공유하는 메모리가 없어, Context Switching가 발생하면 캐시에 있는 모든 데이터를 모두 리셋하고 다시 캐시 정보를 불러와야 한다.
   * **프로세스 사이의 통신 어려움**  
      프로세스는 각각의 독립된 메모리 영역을 할당받았기 때문에 하나의 프로그램에 속하는 프로세스들 사이의 변수를 공유할 수 없어 프로세스 사이의 어렵고 복잡한 통신 기법(IPC)을 사용해야한다.

<br/>

## 멀티 스레드(Multi Thread)

하나의 프로세스에 여러개의 스레드가 있는 것을 말한다. 하나의 프로그램에서 두가지 이상의 동작을 동시에 처리하는 행위가 가능해진다.

윈도우, 리눅스 등 많은 운영체제들이 멀티 프로세싱을 지원하고 있지만 멀티 스레딩을 기본으로 하고 있다. 웹 서버는 대표적인 멀티 스레드 응용 프로그램이다.

일반적으로 멀티스레드르 사용하는 이유는 사용자와 상호작용하는 애플리케이션에서 단일 스레드로 Network 또는 DB 와 같은 긴 작업(Long-running task)을 수행하는 경우 해당 작업을 처리하는 동안 사용자와 상호작용이 불능인 상태가 될 수 있기 때문이다.

* **장점**

   * **사용자에 대한 우수한 응답성**  
      한 스레드가 블록되어도, 다른 스레드들은 여전히 스케줄링되어 실행되기 때문에, 응용프로그램 전체가 블록되는 일이 일어나지 않는다.
   * **시스템 자원 사용의 효율성**  
      프로세스를 생성하여 자원을 할당하는 시스템 콜이 줄어들어 자원을 효율적으로 관리할 수 있고, 시스템 처리량이 증가한다.  
   * **효율적인 통신**  
      스레드는 Stack 영역을 제외한 모든 메모리를 공유하기 때문에 스레드 간의 통신의 비용이 적고, Context Switching이 빠르다.

* **단점**

   * 주의 깊은 설계가 필요하며 디버깅이 까다롭다.  
   * 다른 프로세스에서 스레드를 제어할 수 없다.  
   * 멀티 스레드의 경우 자원 공유의 문제가 발생한다. (동기화 문제)  

<br/>

## 멀티 프로세스와 멀티 스레드 비교 정리

멀티 스레드는 멀티 프로세스에 비해 상당한 이점을 가지며 많이 사용된다. 멀티 프로세스와 비교한 멀티 스레드의 장점과 유의점을 다시 정리하면 다음과 같다.

1. **자원의 효율성 증대**  
   멀티 프로세스로 실행되는 작업을 멀티 스레드로 실행할 경우, 프로세스를 생성하여 자원을 할당하는 시스템 콜이 줄어들어 자원을 효율적으로 관리할 수 있다.  

   프로세스 간의 `Context Switching` 시 단순히 CPU 레지스터 교체 뿐만 아니라 RAM과 CPU 사이의 캐시 메모리에 대한 데이터까지 초기화되므로 오버헤드가 크다. 스레드는 프로세스 내의 메모리를 공유하기 때문에 독립적인 프로세스와 달리 스레드 간 데이터를 주고 받는 것이 간단해지고 시스템 자원 소모가 줄어들게 된다.

2. **처리 비용 감소 및 응답 시간 단축**  
   프로세스 간의 통신(IPC)보다 스레드 간의 통신의 비용이 적으므로 작업들 간의 통신의 부담이 줄어든다.  
   스레드는 Stack 영역을 제외한 모든 메모리를 공유하기 때문에 Context Switching시 스레드는 Stack 영역만 처리한다. 그래서 프로세스보다 스레드 간의 전환 속도가 빠르다.

3. **멀티 스레드의 안정성 문제**  
   단, 프로세스는 독립적인 자원을 할당받으므로 프로세스간의 동기화가 필요하지 않지만, 스레드는 자원을 공유하므로 동기화와 충돌 발생에 유의해야한다.

<br/>

---

## Reference

📄https://cocoon1787.tistory.com/688  
📄https://gmlwjd9405.github.io/2018/09/14/process-vs-thread.html  
📄https://github.com/Songwonseok/CS-Study/blob/main/OS/프로세스vs스레드.md  
📄https://ko.wikipedia.org/wiki/프로세스_간_통신  
📄https://www.charlezz.com/?p=44590
